/////////////////////////////////////////////////////////////
// CINEMA 4D SDK                                           //
/////////////////////////////////////////////////////////////
// (c) 1989-2004 MAXON Computer GmbH, all rights reserved  //
/////////////////////////////////////////////////////////////

// example code for a menu plugin and multiprocessing

#include "c4d.h"
#include "c4d_symbols.h"
#include "c4d_memory_mp.h"


class MPTest : public C4DThread
{
public:
	Random rnd;
	Int32	 start;
	Float	 result;
	Float	 duration;

	virtual void Main(void);
	virtual const Char* GetThreadName(void) { return "SDK MpTest"; }
};

void MPTest::Main(void)
{
	Float64 t1 = GeGetMilliSeconds();

	// calculate the 10,000,000 th random number

	rnd.Init(start);

	Int32 i;
	for (i = 0; i < 10000000; i++)
		rnd.Get01();

	result = rnd.Get01();
	duration = GeGetMilliSeconds() - t1;
}

class ControlThread : public C4DThread
{
public:
	virtual void Main(void);
	virtual const Char* GetThreadName(void) { return "SDK ControlThread"; }
};

void ControlThread::Main(void)
{
	GeShowMouse(MOUSE_BUSY);

	MPThreadPool mp;
	Int32				 i, cnt = GeGetCPUCount();
	if (cnt == 0)
		return;
	MPAlloc<MPTest>				 thread;
	AutoGeFree<C4DThread*> list = NewMemClear(C4DThread *, cnt);
	if (!list || !thread.Init(cnt))
		return;

	for (i = 0; i < cnt; i++)
	{
		thread[i].start	 = i;
		thread[i].result = 0.0;
		list[i] = &thread[i];
	}

	if (!mp.Init(*this, cnt, list))
		return;
	Float64 start_time = GeGetMilliSeconds();
	if (!mp.Start(THREADPRIORITY_BELOW))
		return;
	Float64	start_duration = GeGetMilliSeconds() - start_time;

	mp.Wait();
	Float64 total_duration = GeGetMilliSeconds() - start_time;

	String str = "Multiprocessing Test on " + String::IntToString(cnt) + " CPUs returns:";
	for (i = 0; i < cnt; i++)
		str += " " + String::FloatToString(thread[i].result);

	str += "| Duration per thread:";
	for (i = 0; i < cnt; i++)
	{
		str += " " + String::FloatToString(thread[i].duration) + " ms";
		if (i + 1 < cnt)
			str += ",";
	}

	str += "|Thread start: " + String::FloatToString(start_duration) + " ms";
	str += "|Total duration: " + String::FloatToString(total_duration) + " ms";

	GeShowMouse(MOUSE_NORMAL);

	MessageDialog(str);
}

class MenuTest : public CommandData
{
public:
	virtual Bool Execute(BaseDocument* doc);
};

Bool MenuTest::Execute(BaseDocument* doc)
{
	ControlThread ct;
	return ct.Start(THREADMODE_SYNCHRONOUS);	// multiprocessing test
}

Bool RegisterMenuTest(void)
{
	// be sure to use a unique ID obtained from www.plugincafe.com
	return RegisterCommandPlugin(1000956, GeLoadString(IDS_MENUTEST), 0, AutoBitmap("icon.tif"), String("C++ SDK Menu Test Plugin"), NewObjClear(MenuTest));
}

